*! version 5.0
* 13 August 2018
* NIDS 
* Reshaping the mortality section of the household questionnaire
	* Data is in wide format in questionnaires.
	* Can be useful for it to be in long format for analysis purposes.

*=====================================================================================================================================
* GLOBALS FOR DATA FILES AND VERSION SUFFIXES

* This do-file will reshape Wave 1 to Wave 5

global DataIN "C:\Users\Admin\Desktop\Data"
global DataOUT "C:\Users\Admin\Desktop\Data"
global VersionIN "W5_Anon_V1.0.0"
global VersionOUT "merged"
																		
version 15.1													// version of Stata being used, this is needed for the rename command.

*=====================================================================================================================================

* OPENING THE HOUSEHOLD QUESTIONNAIRE, KEEPING RELEVANT VARIABLES AND RESHAPING THE MORTALITY SECTION

use "$DataIN\HHQuestionnaire_$VersionIN.dta", clear					// opening the Household questionnaire data

rename w#_h_* *
cap keep if  outcome == 1											// keeping households that were successfully interviewed
keep if  mrt24mnth == 1												// keeping households that had a death in the past 24 months 

keep  *hhid mrt*													// keeping the relevant variables
drop mrt24mnth

forvalues x = 1/6 {													// renaming the mortality cause other
cap rename mrtcau`x'_o mrtcau_o`x'
}

reshape long  mrtgen mrtr mrtdod_m mrtdod_y mrtage mrtcau mrtcau_o mrtliv  ///
mrtacc mrtpid, i(*hhid) j(mort) string								// reshaping the mortality section to long format
destring mort, replace												// destringing mort number
cap order mrtcau_o, after(mrtcau)

drop if  mrtgen == .												// dropping empty records

foreach x of varlist mrtliv mrtcau mrtcau_o mrtacc mrtpid {			// dropping empty variables
quietly sum `x'
	if r(N) == 0 {
	drop `x'
	}
}	

* labeling the variables
label var 	mort 		"Number of deceased person"
label var	mrtgen		"c3 - What the deceased's gender?"
label var	mrtr		"c4 - Relationship of deceased to Household Head"
label var	mrtdod_m	"c5_m - Date of death for person 1 - month only"
label var	mrtdod_y	"c5_y - Date of death for person 1 - year only"
label var	mrtage		"c6 - Age in years"
cap label var 	mrtliv		"c7_1 - Was deceased living here when he/she died?"
cap label var	mrtacc		"c8 - Cause of death natural?"
cap label var	mrtpid		"c_pid - deceased's pid"
cap label var	mrtcau	"c8 - Cause of death"
cap label var	mrtcau_o	"c8_o- If other cause of death is given, specify"

save "$DataOUT\Mortality_Section_$VersionOUT.dta", replace			// saving out the dataset

* end of do file

*===========================================================================================================================================
